/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;
import oreexcavation.core.ExcavationSettings;

public class ToolEffectiveCheck {
    public static boolean canHarvestBlock(World world, BlockState state, BlockPos pos, PlayerEntity player) {
        if (world == null || state == null || pos == null || player == null) {
            return false;
        }
        ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
        if (ExcavationSettings.openHand && held.func_190926_b()) {
            return state.func_177230_c().canHarvestBlock(state, (IBlockReader)world, pos, player);
        }
        if (ExcavationSettings.toolClass) {
            if (held.func_190926_b()) {
                return false;
            }
            if (held.func_77973_b() instanceof ShearsItem && state.func_177230_c() instanceof IShearable) {
                return true;
            }
            for (ToolType type : held.func_77973_b().getToolTypes(held)) {
                if (type == state.func_177230_c().getHarvestTool(state) && held.func_77973_b().getHarvestLevel(held, type, player, state) >= state.func_177230_c().getHarvestLevel(state)) {
                    return true;
                }
                if (!state.func_177230_c().isToolEffective(state, type)) continue;
                return true;
            }
            return false;
        }
        if (ExcavationSettings.altTools && !held.func_190926_b() && held.func_150997_a(state) > 1.0f) {
            return true;
        }
        if (!held.func_190926_b() && held.func_77973_b() instanceof ShearsItem && state.func_177230_c() instanceof IShearable) {
            return true;
        }
        return state.func_177230_c().canHarvestBlock(state, (IBlockReader)world, pos, player);
    }
}

