/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeListBuilder {
    private final Set<Biome> extras = new HashSet<Biome>();
    private final Set<BiomeDictionary.Type> list = new HashSet<BiomeDictionary.Type>();
    private final Set<BiomeDictionary.Type> blacklist = new HashSet<BiomeDictionary.Type>();
    private final Set<Biome> blacklistBiome = new HashSet<Biome>();
    private final Set<BiomeDictionary.Type> required = new HashSet<BiomeDictionary.Type>();

    private BiomeListBuilder() {
    }

    public static BiomeListBuilder create() {
        return new BiomeListBuilder();
    }

    public BiomeListBuilder extra(Biome ... extraBiomes) {
        for (Biome biome : extraBiomes) {
            this.extras.add(biome);
        }
        return this;
    }

    public BiomeListBuilder extra(BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            this.list.add(type);
        }
        return this;
    }

    public BiomeListBuilder withoutTypes(BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            this.blacklist.add(type);
        }
        return this;
    }

    public BiomeListBuilder withTypes(BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            this.required.add(type);
        }
        return this;
    }

    public BiomeListBuilder withoutBiomes(Biome ... biomes) {
        for (Biome biome : biomes) {
            this.blacklistBiome.add(biome);
        }
        return this;
    }

    public Biome[] collect() {
        HashSet<Biome> set = new HashSet<Biome>();
        set.addAll(this.extras);
        for (BiomeDictionary.Type extraT : this.list) {
            set.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)extraT));
        }
        if (this.required.size() > 0 || this.blacklist.size() > 0) {
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                Set types = BiomeDictionary.getTypes((Biome)biome);
                if (types == null) continue;
                boolean pass = true;
                for (BiomeDictionary.Type type : this.required) {
                    if (types.contains(type)) continue;
                    pass = false;
                }
                for (BiomeDictionary.Type type : this.blacklist) {
                    if (!types.contains(type)) continue;
                    pass = false;
                }
                if (this.blacklistBiome.contains(biome)) {
                    pass = false;
                }
                if (!pass) continue;
                set.add(biome);
            }
        }
        return set.toArray(new Biome[0]);
    }
}

