/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.config;

import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainer;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerTameable;
import its_meow.betteranimalsplus.init.ModEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="betteranimalsplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterAnimalsPlusConfig {
    private static ServerConfig SERVER_CONFIG = null;
    public static ForgeConfigSpec SERVER_CONFIG_SPEC = null;
    private static ClientConfig CLIENT_CONFIG = null;
    public static ForgeConfigSpec CLIENT_CONFIG_SPEC = null;
    public static boolean coyotesHostileDaytime;
    public static boolean biomeBasedVariants;
    public static boolean goatVanillaMilk;

    public static void setupConfig() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER_CONFIG = (ServerConfig)specPair.getLeft();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        BetterAnimalsPlusMod.logger.debug("Loading {} {}", (Object)"betteranimalsplus", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG_SPEC) {
            SERVER_CONFIG.onWorldLoad();
        } else if (configEvent.getConfig().getSpec() == CLIENT_CONFIG_SPEC) {
            CLIENT_CONFIG.loadData();
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Reloading configEvent) {
        BetterAnimalsPlusMod.logger.debug("Reloading {} {}", (Object)"betteranimalsplus", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == SERVER_CONFIG_SPEC) {
            SERVER_CONFIG.loadData();
        } else if (configEvent.getConfig().getSpec() == CLIENT_CONFIG_SPEC) {
            CLIENT_CONFIG.loadData();
        }
    }

    public static Map<String, String[]> getTameItemsMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (EntityTypeContainer<? extends MobEntity> cont : ModEntities.ENTITIES.values()) {
            if (!(cont instanceof EntityTypeContainerTameable)) continue;
            EntityTypeContainerTameable cont2 = (EntityTypeContainerTameable)cont;
            map.put(cont2.entityName, cont2.getTameItems());
        }
        return map;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT_CONFIG = (ClientConfig)specPair.getLeft();
        coyotesHostileDaytime = false;
        biomeBasedVariants = false;
        goatVanillaMilk = false;
    }

    public static class ServerConfig {
        public ForgeConfigSpec.Builder builder;
        private final ForgeConfigSpec.BooleanValue biomeBasedVariants;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
            for (EntityTypeContainer<? extends MobEntity> cont : ModEntities.ENTITIES.values()) {
                cont.initConfiguration(builder);
            }
            builder.push("misc");
            this.biomeBasedVariants = builder.comment("Setting to true enables biome based variant spawning. This will make some entities choose variants based on the biome they spawn in. (No longer affects spawn eggs as it did in the past, only natural spawns)").worldRestart().define("biomeBasedVariants", true);
            builder.pop();
            builder.build();
        }

        public void loadData() {
            for (EntityTypeContainer<? extends MobEntity> container : ModEntities.ENTITIES.values()) {
                EntityTypeContainer.EntityConfiguration section = container.getConfiguration();
                container.configurationLoad();
                ArrayList<Biome> biomesList = new ArrayList<Biome>();
                for (String biomeID : (List)section.biomesList.get()) {
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeID));
                    if (biome == null) {
                        BetterAnimalsPlusMod.logger.error("Invalid biome configuration entered for entity \"" + container.entityName + "\" (biome was mistyped or a biome mod was removed?): " + biomeID);
                        continue;
                    }
                    biomesList.add(biome);
                }
                container.setBiomes(biomesList.toArray(new Biome[0]));
            }
        }

        public void onWorldLoad() {
            biomeBasedVariants = (Boolean)this.biomeBasedVariants.get();
            this.loadData();
            if (!ModEntities.ENTITIES.values().isEmpty()) {
                for (EntityTypeContainer<? extends MobEntity> entry : ModEntities.ENTITIES.values()) {
                    EntityType type = entry.entityType;
                    if (!entry.doSpawning) continue;
                    entry.registerPlacement();
                    for (Biome biome : entry.getBiomes()) {
                        biome.func_201866_a(entry.spawnType, new Biome.SpawnListEntry(type, entry.spawnWeight, entry.spawnMinGroup, entry.spawnMaxGroup));
                    }
                }
            }
        }
    }

    public static class ClientConfig {
        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"This is the CLIENTSIDE configuration for Better Animals Plus.", "To configure SERVER values (spawning, behavior, etc), go to:", "saves/(world)/serverconfig/betteranimalsplus-server.toml", "or, on a dedicated server:", "(world)/serverconfig/betteranimalsplus-server.toml"});
            for (EntityTypeContainer<? extends MobEntity> cont : ModEntities.ENTITIES.values()) {
                cont.clientCustomConfigurationInit(builder);
            }
            builder.build();
        }

        public void loadData() {
            ModEntities.ENTITIES.values().forEach(EntityTypeContainer::clientConfigurationLoad);
        }
    }
}

