/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.item;

import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainer;
import its_meow.betteranimalsplus.common.entity.util.IBucketable;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModFishBucket<T extends MobEntity>
extends BucketItem {
    public static final IBucketTooltipFunction defaultVariantFunc = (container, stack, world, tooltip) -> {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("BucketVariantTag", 8)) {
            String id = compoundnbt.func_74779_i("BucketVariantTag");
            TextFormatting[] atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            tooltip.add(new TranslationTextComponent("entity.betteranimalsplus." + container.entityName.toLowerCase() + ".type." + container.getVariant(id).getName(), new Object[0]).func_211709_a(atextformatting));
        }
    };
    private final EntityTypeContainer<T> typeContainer;
    private IBucketTooltipFunction tooltip;

    public ItemModFishBucket(EntityTypeContainer<T> typeContainer, Supplier<? extends Fluid> fluid, IBucketTooltipFunction tooltip) {
        super(fluid, new Item.Properties().func_200917_a(1).func_200916_a(BetterAnimalsPlusMod.group));
        this.typeContainer = typeContainer;
        this.setRegistryName(typeContainer.entityName + "_bucket");
        this.tooltip = tooltip;
    }

    public void func_203792_a(World worldIn, ItemStack stack, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            this.placeFish(worldIn, stack, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeFish(World worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.getFishType().func_220331_a(worldIn, stack, (PlayerEntity)null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null && entity instanceof IBucketable) {
            ((IBucketable)entity).setFromBucket(true);
            ((IBucketable)entity).readFromBucket(stack);
            if (stack.func_77978_p() != null) {
                ((IBucketable)entity).readFromBucketTag(stack.func_77978_p());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.tooltip.addInformation(this.typeContainer, stack, worldIn, tooltip);
    }

    public EntityTypeContainer<T> getContainer() {
        return this.typeContainer;
    }

    public EntityType<T> getFishType() {
        return this.typeContainer.entityType;
    }

    @FunctionalInterface
    public static interface IBucketTooltipFunction {
        public void addInformation(EntityTypeContainer<? extends MobEntity> var1, ItemStack var2, @Nullable World var3, List<ITextComponent> var4);
    }
}

