/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity.util;

import its_meow.betteranimalsplus.common.entity.util.IVariantTypes;
import its_meow.betteranimalsplus.config.BetterAnimalsPlusConfig;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public interface ISelectiveVariantTypes<T extends MobEntity>
extends IVariantTypes<T> {
    @Override
    @Nullable
    default public ILivingEntityData initData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        if (BetterAnimalsPlusConfig.biomeBasedVariants && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL)) {
            Biome biome = world.func_226691_t_(this.getImplementation().func_180425_c());
            String[] validTypes = this.getTypesFor(biome, BiomeDictionary.getTypes((Biome)biome));
            String variant = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
            if (livingdata instanceof IVariantTypes.TypeData) {
                variant = ((IVariantTypes.TypeData)livingdata).typeData;
            } else {
                livingdata = new IVariantTypes.TypeData(variant);
            }
            this.setType(variant);
        } else {
            String variant = this.getRandomType().getName();
            if (livingdata instanceof IVariantTypes.TypeData) {
                variant = ((IVariantTypes.TypeData)livingdata).typeData;
            } else {
                livingdata = new IVariantTypes.TypeData(variant);
            }
            this.setType(variant);
        }
        return livingdata;
    }

    @Override
    @Nullable
    default public ILivingEntityData initAgeableData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        if (BetterAnimalsPlusConfig.biomeBasedVariants && (reason == SpawnReason.CHUNK_GENERATION || reason == SpawnReason.NATURAL)) {
            Biome biome = world.func_226691_t_(this.getImplementation().func_180425_c());
            String[] validTypes = this.getTypesFor(biome, BiomeDictionary.getTypes((Biome)biome));
            String variant = validTypes[this.getImplementation().func_70681_au().nextInt(validTypes.length)];
            if (livingdata instanceof IVariantTypes.AgeableTypeData) {
                variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
            } else {
                livingdata = livingdata instanceof AgeableEntity.AgeableData ? new IVariantTypes.AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
            }
            this.setType(variant);
        } else {
            String variant = this.getRandomType().getName();
            if (livingdata instanceof IVariantTypes.AgeableTypeData) {
                variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
            } else {
                livingdata = livingdata instanceof AgeableEntity.AgeableData ? new IVariantTypes.AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
            }
            this.setType(variant);
        }
        return livingdata;
    }

    public String[] getTypesFor(Biome var1, Set<BiomeDictionary.Type> var2);
}

