/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity.util;

import com.google.common.collect.ImmutableList;
import its_meow.betteranimalsplus.common.entity.util.EntityVariant;
import its_meow.betteranimalsplus.common.entity.util.IVariant;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;

public class EntityVariantList {
    private final ArrayList<IVariant> variantList;
    private final HashMap<String, IVariant> nameMap;
    private static final IVariant EMPTY_VARIANT = new EntityVariant("empty", false);

    public EntityVariantList(int size) {
        this.variantList = new ArrayList(size);
        this.nameMap = new HashMap(size);
    }

    public IVariant getVariant(int index) {
        return this.variantList.get(index);
    }

    public int getVariantIndex(String variant) {
        return this.variantList.indexOf(this.getVariant(variant));
    }

    public int getVariantIndex(IVariant variant) {
        return this.variantList.indexOf(variant);
    }

    public IVariant getVariant(String name) {
        if (!this.nameMap.containsKey(name)) {
            return EMPTY_VARIANT;
        }
        return this.nameMap.get(name);
    }

    public ResourceLocation getTexture(String name) {
        return this.getVariant(name).getTexture();
    }

    public String getName(String name) {
        return this.getVariant(name).getName();
    }

    public ImmutableList<IVariant> getVariantList() {
        return ImmutableList.copyOf(this.variantList);
    }

    public void add(IVariant ... variants) {
        for (IVariant variant : variants) {
            this.variantList.add(variant);
            this.nameMap.put(variant.getName(), variant);
        }
    }
}

