/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import com.google.common.base.Predicates;
import its_meow.betteranimalsplus.common.entity.EntityGoat;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerTameable;
import its_meow.betteranimalsplus.common.entity.util.IDropHead;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityTameableWithSelectiveTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityFeralWolf
extends EntityTameableWithSelectiveTypes
implements IMob,
IDropHead {
    protected static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityFeralWolf.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> TYPE_NUMBER = EntityDataManager.func_187226_a(EntityFeralWolf.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected float headRotationCourse;
    protected float headRotationCourseOld;
    protected boolean isWet;
    protected boolean isShaking;
    protected float timeWolfIsShaking;
    protected float prevTimeWolfIsShaking;
    public SitGoal aiSit;

    public EntityFeralWolf(World worldIn) {
        super((EntityType<? extends EntityTameableWithSelectiveTypes>)ModEntities.FERAL_WOLF.entityType, worldIn);
        this.field_70170_p = worldIn;
        this.func_70903_f(false);
    }

    public EntityFeralWolf(EntityType<? extends EntityFeralWolf> type, World worldIn) {
        super((EntityType<? extends EntityTameableWithSelectiveTypes>)type, worldIn);
        this.field_70170_p = worldIn;
    }

    protected void func_184651_r() {
        this.aiSit = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, false, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, p_apply_1_ -> p_apply_1_ instanceof SheepEntity || p_apply_1_ instanceof RabbitEntity));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, VillagerEntity.class, false, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AbstractIllagerEntity.class, false, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, ChickenEntity.class, false, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, EntityGoat.class, false, (Predicate)Predicates.alwaysTrue()));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    public boolean isPreventingPlayerRest(PlayerEntity playerIn) {
        return this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && !this.func_70909_n() && this.func_70638_az() != null && playerIn.func_70068_e((Entity)this) <= 50.0;
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        if (!this.func_70909_n() || this.func_70638_az() != null) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f;
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)f1, (double)(f + 0.8f), this.func_226281_cx_() + (double)f2, this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isWolfWet() {
        return this.isWet;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70915_1_) / 2.0f * 0.25f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.aiSit != null) {
            this.aiSit.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            Food food;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_219971_r() && (food = itemstack.func_77973_b().func_219967_s()).func_221467_c() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 20.0f) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(food.func_221466_a());
                return true;
            }
            if (!(!this.func_152114_e((LivingEntity)player) || this.field_70170_p.field_72995_K || this.func_70877_b(itemstack) || itemstack.func_77973_b().func_219971_r() && itemstack.func_77973_b().func_219967_s().func_221467_c())) {
                this.aiSit.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (this.isTamingItem(itemstack.func_77973_b())) {
            boolean wearingPowerHead = false;
            ItemStack stack = player.func_184582_a(EquipmentSlotType.HEAD);
            if (stack.func_77973_b() == Items.field_196151_dA) {
                wearingPowerHead = true;
            }
            if (stack.func_77973_b() == ModItems.HIRSCHGEIST_SKULL_WEARABLE) {
                wearingPowerHead = true;
            }
            if (wearingPowerHead) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(100) <= 14 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                        this.func_193101_c(player);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.aiSit.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new StringTextComponent("You cannot tame feral wolves without proving your prowess. Discover a mighty enemy, defeat it, and wear its head. Feral Wolves only bow to the protector of the forests."));
            }
        }
        return super.func_184645_a(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (!this.func_70909_n()) {
            return -0.15f;
        }
        return this.func_70909_n() ? 0.25f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) * 0.04f : -0.85f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            EntityFeralWolf entityferalwolf;
            if (target instanceof EntityFeralWolf && (entityferalwolf = (EntityFeralWolf)target).func_70909_n() && entityferalwolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }

    @Override
    protected EntityFeralWolf getBaseChild() {
        return null;
    }

    @Override
    public String[] getTypesFor(Biome biome, Set<BiomeDictionary.Type> types) {
        if (types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            return new String[]{"timber", "red"};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"black", "timber", "red"};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"snowy", "timber"};
        }
        if (types.contains(BiomeDictionary.Type.SNOWY) && !types.contains(BiomeDictionary.Type.FOREST)) {
            return new String[]{"snowy", "arctic"};
        }
        if (types.contains(BiomeDictionary.Type.FOREST) && types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"brown", "red", "timber", "black"};
        }
        return new String[]{"black", "snowy", "timber", "arctic", "brown", "red"};
    }

    protected ResourceLocation func_184647_J() {
        switch (this.getVariantName()) {
            case "black": {
                return ModLootTables.WOLF_BLACK;
            }
            case "snowy": {
                return ModLootTables.WOLF_SNOWY;
            }
            case "timber": {
                return ModLootTables.WOLF_TIMBER;
            }
            case "arctic": {
                return ModLootTables.WOLF_ARCTIC;
            }
            case "brown": {
                return ModLootTables.WOLF_BROWN;
            }
            case "red": {
                return ModLootTables.WOLF_RED;
            }
        }
        return null;
    }

    @Override
    public EntityTypeContainerTameable<? extends EntityTameableWithSelectiveTypes> getContainer() {
        return ModEntities.FERAL_WOLF;
    }
}

