/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.client;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import its_meow.betteranimalsplus.BetterAnimalsPlusMod;
import its_meow.betteranimalsplus.client.model.ModelBadger;
import its_meow.betteranimalsplus.client.model.ModelBear;
import its_meow.betteranimalsplus.client.model.ModelBoar;
import its_meow.betteranimalsplus.client.model.ModelBobbitWorm;
import its_meow.betteranimalsplus.client.model.ModelCrab;
import its_meow.betteranimalsplus.client.model.ModelDeer;
import its_meow.betteranimalsplus.client.model.ModelFreshwaterEel;
import its_meow.betteranimalsplus.client.model.ModelGoat;
import its_meow.betteranimalsplus.client.model.ModelHorseshoeCrab;
import its_meow.betteranimalsplus.client.model.ModelLammergeier;
import its_meow.betteranimalsplus.client.model.ModelMoose;
import its_meow.betteranimalsplus.client.model.ModelNautilus;
import its_meow.betteranimalsplus.client.model.ModelReindeer;
import its_meow.betteranimalsplus.client.model.ModelSaltwaterEel;
import its_meow.betteranimalsplus.client.model.ModelSquirrel;
import its_meow.betteranimalsplus.client.model.ModelTarantula;
import its_meow.betteranimalsplus.client.model.ModelWalrus;
import its_meow.betteranimalsplus.client.model.ModelZotzpyre;
import its_meow.betteranimalsplus.client.renderer.entity.RenderCoyote;
import its_meow.betteranimalsplus.client.renderer.entity.RenderCustomWolf;
import its_meow.betteranimalsplus.client.renderer.entity.RenderGoose;
import its_meow.betteranimalsplus.client.renderer.entity.RenderHirschgeist;
import its_meow.betteranimalsplus.client.renderer.entity.RenderJellyfish;
import its_meow.betteranimalsplus.client.renderer.entity.RenderLamprey;
import its_meow.betteranimalsplus.client.renderer.entity.RenderPheasant;
import its_meow.betteranimalsplus.client.renderer.entity.RenderShark;
import its_meow.betteranimalsplus.client.renderer.entity.RenderSongbird;
import its_meow.betteranimalsplus.client.renderer.entity.RenderTarantulaHair;
import its_meow.betteranimalsplus.client.renderer.entity.RenderTurkey;
import its_meow.betteranimalsplus.client.renderer.entity.RenderWhale;
import its_meow.betteranimalsplus.client.renderer.entity.generic.RenderNothing;
import its_meow.betteranimalsplus.client.renderer.entity.generic.SimpleRenderer;
import its_meow.betteranimalsplus.client.renderer.entity.generic.SimpleScaledRenderer;
import its_meow.betteranimalsplus.client.renderer.entity.generic.SimpleScaledSingleRenderer;
import its_meow.betteranimalsplus.client.renderer.entity.generic.SimpleSingleRenderer;
import its_meow.betteranimalsplus.client.renderer.entity.layers.LayerEyesCondition;
import its_meow.betteranimalsplus.client.renderer.tileentity.RenderBlockHandOfFate;
import its_meow.betteranimalsplus.client.renderer.tileentity.RenderBlockTrillium;
import its_meow.betteranimalsplus.client.renderer.tileentity.RenderGenericHead;
import its_meow.betteranimalsplus.common.entity.EntityTarantula;
import its_meow.betteranimalsplus.common.entity.projectile.EntityBadgerDirt;
import its_meow.betteranimalsplus.common.entity.projectile.EntityGoldenGooseEgg;
import its_meow.betteranimalsplus.common.entity.projectile.EntityGooseEgg;
import its_meow.betteranimalsplus.common.entity.projectile.EntityPheasantEgg;
import its_meow.betteranimalsplus.common.entity.projectile.EntityTarantulaHair;
import its_meow.betteranimalsplus.common.entity.projectile.EntityTurkeyEgg;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModTextures;
import its_meow.betteranimalsplus.init.ModTileEntities;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientLifecycleHandler {
    public void clientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)ModEntities.HIRSCHGEIST.getHeadType().getBlock(), (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer(ModTileEntities.TRILLIUM_TYPE, RenderBlockTrillium::new);
        ClientRegistry.bindTileEntityRenderer(ModTileEntities.HAND_OF_FATE_TYPE, RenderBlockHandOfFate::new);
        ClientRegistry.bindTileEntityRenderer(ModTileEntities.HEAD_TYPE, RenderGenericHead::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BROWN_BEAR.entityType, ClientLifecycleHandler.simpleScaledSingle(new ModelBear(), 1.0f, ModTextures.bear_brown, 1.3, 1.3));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BLACK_BEAR.entityType, ClientLifecycleHandler.simple(new ModelBear(), 1.0f));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.DEER.entityType, ClientLifecycleHandler.simpleScaled(new ModelDeer(), 1.0f, 1.0, 0.6));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)ModEntities.LAMMERGEIER.entityType, ClientLifecycleHandler.simple(new ModelLammergeier(), 0.3f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)ModEntities.FERAL_WOLF.entityType, RenderCustomWolf::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)ModEntities.COYOTE.entityType, RenderCoyote::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTarantulaHair.HAIR_TYPE, RenderTarantulaHair::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.TARANTULA.entityType, mgr -> new SimpleSingleRenderer<EntityTarantula, ModelTarantula<EntityTarantula>>(mgr, new ModelTarantula(), 1.0f, ModTextures.tarantula){

            protected void preRenderCallback(EntityTarantula entity, MatrixStack stack, float partialTickTime) {
                if (entity.func_70841_p()) {
                    stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                    stack.func_227861_a_(0.0, 0.75, -0.5);
                }
            }
        }.layer(base -> new LayerEyesCondition(base, ModTextures.tarantula_eyes, Predicates.alwaysTrue())));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.HIRSCHGEIST.entityType, RenderHirschgeist::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.GOAT.entityType, ClientLifecycleHandler.simpleScaled(new ModelGoat(), 0.5f, 1.0, 0.5));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.JELLYFISH.entityType, RenderJellyfish::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.PHEASANT.entityType, RenderPheasant::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.REINDEER.entityType, ClientLifecycleHandler.simpleScaled(new ModelReindeer(), 1.0f, 1.3, 0.7));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOAR.entityType, ClientLifecycleHandler.simpleScaled(new ModelBoar(), 0.6f, 1.0, 0.6));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SQUIRREL.entityType, ClientLifecycleHandler.simpleScaled(new ModelSquirrel(), 0.3f, 0.5, 0.35));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SONGBIRD.entityType, RenderSongbird::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BADGER.entityType, ClientLifecycleHandler.simpleScaled(new ModelBadger(), 0.4f, 0.7, 0.35));
        RenderingRegistry.registerEntityRenderingHandler(EntityBadgerDirt.DIRT_TYPE, ClientLifecycleHandler.nothing());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.LAMPREY.entityType, RenderLamprey::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.NAUTILUS.entityType, ClientLifecycleHandler.simpleSingle(new ModelNautilus(), 0.4f, ModTextures.nautilus));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CRAB.entityType, ClientLifecycleHandler.simpleScaled(new ModelCrab(), 0.4f, 1.0, 0.45));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.HORSESHOE_CRAB.entityType, ClientLifecycleHandler.simpleScaled(new ModelHorseshoeCrab(), 0.4f, 1.0, 0.45));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SHARK.entityType, RenderShark::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MOOSE.entityType, ClientLifecycleHandler.simpleScaled(new ModelMoose(), 0.8f, 1.5, 1.5));
        RenderingRegistry.registerEntityRenderingHandler(EntityPheasantEgg.PHEASANT_EGG_TYPE, ClientLifecycleHandler.sprite());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.TURKEY.entityType, RenderTurkey::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityTurkeyEgg.TURKEY_EGG_TYPE, ClientLifecycleHandler.sprite());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ZOTZPYRE.entityType, ClientLifecycleHandler.simpleEyes(new ModelZotzpyre(), 0.4f, ModTextures.zotzpyre_eyes, Predicates.alwaysTrue()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOBBIT_WORM.entityType, ClientLifecycleHandler.simple(new ModelBobbitWorm(), 0.4f));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.GOOSE.entityType, RenderGoose::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGooseEgg.GOOSE_EGG_TYPE, ClientLifecycleHandler.sprite());
        RenderingRegistry.registerEntityRenderingHandler(EntityGoldenGooseEgg.GOLDEN_GOOSE_EGG_TYPE, ClientLifecycleHandler.sprite());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.EEL_FRESHWATER.entityType, ClientLifecycleHandler.simple(new ModelFreshwaterEel(), 0.4f));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.EEL_SALTWATER.entityType, ClientLifecycleHandler.simple(new ModelSaltwaterEel(), 0.4f));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.WHALE.entityType, RenderWhale::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.WALRUS.entityType, ClientLifecycleHandler.simpleSingle(new ModelWalrus(), 1.5f, ModTextures.walrus));
        BetterAnimalsPlusMod.logger.info("Rendering squirrel physics...");
    }

    private static <T extends Entity> IRenderFactory<T> nothing() {
        return RenderNothing::new;
    }

    private static <T extends Entity> IRenderFactory<T> sprite() {
        return mgr -> new SpriteRenderer(mgr, Minecraft.func_71410_x().func_175599_af());
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simple(A model, float shadowSize) {
        return mgr -> new SimpleRenderer(mgr, model, shadowSize);
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simpleScaled(A model, float shadowSize, double adultScale, double childScale) {
        return mgr -> new SimpleScaledRenderer(mgr, model, shadowSize, adultScale, childScale);
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simpleSingle(A model, float shadowSize, ResourceLocation texture) {
        return mgr -> new SimpleSingleRenderer(mgr, model, shadowSize, texture);
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simpleScaledSingle(A model, float shadowSize, ResourceLocation texture, double adultScale, double childScale) {
        return mgr -> new SimpleScaledSingleRenderer(mgr, model, shadowSize, texture, adultScale, childScale);
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simpleEyes(A model, float shadowSize, ResourceLocation eyes, Predicate<T> showEyes) {
        return mgr -> new SimpleRenderer(mgr, model, shadowSize).layer(base -> new LayerEyesCondition(base, eyes, showEyes));
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simpleScaledEyes(A model, float shadowSize, double adultScale, double childScale, ResourceLocation eyes, Predicate<T> showEyes) {
        return mgr -> new SimpleScaledRenderer(mgr, model, shadowSize, adultScale, childScale).layer(base -> new LayerEyesCondition(base, eyes, showEyes));
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simpleSingleEyes(A model, float shadowSize, ResourceLocation texture, ResourceLocation eyes, Predicate<T> showEyes) {
        return mgr -> new SimpleSingleRenderer(mgr, model, shadowSize, texture).layer(base -> new LayerEyesCondition(base, eyes, showEyes));
    }

    private static <T extends MobEntity, A extends EntityModel<T>> IRenderFactory<T> simpleScaledSingleEyes(A model, float shadowSize, ResourceLocation texture, double adultScale, double childScale, ResourceLocation eyes, Predicate<T> showEyes) {
        return mgr -> new SimpleScaledSingleRenderer(mgr, model, shadowSize, texture, adultScale, childScale).layer(base -> new LayerEyesCondition(base, eyes, showEyes));
    }
}

