/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.KitchenSinkTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.ForgeHooksClient;

public class KitchenSinkTileEntityRenderer
extends TileEntityRenderer<KitchenSinkTileEntity> {
    public KitchenSinkTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void func_225616_a_(KitchenSinkTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, int i1) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Direction direction = (Direction)tileEntity.func_195044_w().func_177229_b((IProperty)FurnitureHorizontalBlock.DIRECTION);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)direction.func_176736_b() * -90.0f - 90.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        this.drawFluid(tileEntity, matrixStack, 0.125, 0.625, 0.125, 0.625, 0.3125, 0.75, light);
        matrixStack.func_227865_b_();
    }

    private void drawFluid(KitchenSinkTileEntity te, MatrixStack matrixStack, double x, double y, double z, double width, double height, double depth, int light) {
        Fluid fluid = te.getTank().getFluid().getFluid();
        if (fluid == Fluids.field_204541_a) {
            return;
        }
        TextureAtlasSprite sprite = ForgeHooksClient.getFluidSprites((ILightReader)te.func_145831_w(), (BlockPos)te.func_174877_v(), (IFluidState)fluid.func_207188_f())[0];
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        float minU = sprite.func_94209_e();
        float maxU = (float)Math.min((double)minU + (double)(sprite.func_94212_f() - minU) * depth, (double)sprite.func_94212_f());
        float minV = sprite.func_94206_g();
        float maxV = (float)Math.min((double)minV + (double)(sprite.func_94210_h() - minV) * width, (double)sprite.func_94210_h());
        int waterColor = fluid.getAttributes().getColor((ILightReader)te.func_145831_w(), te.func_174877_v());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        height *= (double)te.getTank().getFluidAmount() / (double)te.getTank().getCapacity();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderHelper.func_227780_a_();
        RenderSystem.enableDepthTest();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        buffer.func_225582_a_(x, y + height, z).func_225583_a_(maxU, minV).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(light).func_181675_d();
        buffer.func_225582_a_(x, y + height, z + depth).func_225583_a_(minU, minV).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(light).func_181675_d();
        buffer.func_225582_a_(x + width, y + height, z + depth).func_225583_a_(minU, maxV).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(light).func_181675_d();
        buffer.func_225582_a_(x + width, y + height, z).func_225583_a_(maxU, maxV).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(light).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableDepthTest();
        RenderHelper.func_74518_a();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }
}

