/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.KitchenSinkTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;

public class KitchenSinkBlock
extends FurnitureHorizontalBlock {
    private boolean bigSink;
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public KitchenSinkBlock(Block.Properties properties, boolean bigSink) {
        super(properties);
        this.bigSink = bigSink;
    }

    private VoxelShape getShape(BlockState state) {
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        Direction direction = (Direction)state.func_177229_b((IProperty)DIRECTION);
        if (this.bigSink) {
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)15.0), Direction.SOUTH))[direction.func_176736_b()]);
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH))[direction.func_176736_b()]);
        } else {
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), Direction.SOUTH))[direction.func_176736_b()]);
            shapes.add(VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH))[direction.func_176736_b()]);
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            return FluidUtil.interactWithFluidHandler((PlayerEntity)playerEntity, (Hand)hand, (World)world, (BlockPos)pos, (Direction)result.func_216354_b()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KitchenSinkTileEntity();
    }
}

