/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MilkJarTileEntity
extends TileEntity {
    protected static final int MILK_CAPACITY = 32000;
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            Fluid milkFluid = Compat.getMilkFluid();
            return milkFluid != null ? new FluidStack(milkFluid, (int)MilkJarTileEntity.this.milkAmount) : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 32000;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Compat.getMilkFluid()) {
                return MilkJarTileEntity.this.fill(resource.getAmount(), action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            Fluid milkFluid = Compat.getMilkFluid();
            if (milkFluid != null && resource.getFluid() == milkFluid) {
                return new FluidStack(milkFluid, MilkJarTileEntity.this.drain(resource.getAmount(), action));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            Fluid milkFluid = Compat.getMilkFluid();
            if (milkFluid != null) {
                return new FluidStack(milkFluid, MilkJarTileEntity.this.drain(maxDrain, action));
            }
            return FluidStack.EMPTY;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return stack.getFluid() == Compat.getMilkFluid();
        }
    };
    private final LazyOptional<IFluidHandler> fluidHandlerCap = LazyOptional.of(() -> this.fluidHandler);
    private final LazyOptional<IKitchenItemProvider> itemProviderCap = LazyOptional.of(() -> this.itemProvider);
    protected float milkAmount;

    public MilkJarTileEntity() {
        super(ModTileEntities.milkJar);
    }

    protected MilkJarTileEntity(TileEntityType<? extends MilkJarTileEntity> type) {
        super(type);
    }

    public int fill(int amount, IFluidHandler.FluidAction action) {
        int filled = (int)Math.min(32000.0f - this.milkAmount, (float)amount);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.milkAmount += (float)filled;
            VanillaPacketHandler.sendTileEntityUpdate(this);
        }
        return filled;
    }

    public int drain(int amount, IFluidHandler.FluidAction action) {
        int drained = (int)Math.min(this.milkAmount, (float)amount);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.milkAmount -= (float)drained;
            VanillaPacketHandler.sendTileEntityUpdate(this);
        }
        return drained;
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74776_a("MilkAmount", this.milkAmount);
        return tagCompound;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.milkAmount = tagCompound.func_74760_g("MilkAmount");
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public float getMilkAmount() {
        return this.milkAmount;
    }

    public float getMilkCapacity() {
        return 32000.0f;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        LazyOptional result = CapabilityKitchenItemProvider.CAPABILITY.orEmpty(capability, this.itemProviderCap);
        if (!result.isPresent() && Compat.getMilkFluid() != null) {
            result = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(capability, this.fluidHandlerCap);
        }
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(capability, facing);
    }

    private static class MilkJarItemProvider
    extends DefaultKitchenItemProvider {
        private final NonNullList<ItemStack> itemStacks = NonNullList.func_191196_a();
        private final MilkJarTileEntity tileMilkJar;
        private int milkUsed;

        public MilkJarItemProvider(MilkJarTileEntity tileMilkJar) {
            this.tileMilkJar = tileMilkJar;
            this.itemStacks.addAll(CookingRegistry.getMilkItems());
        }

        @Override
        public void resetSimulation() {
            this.milkUsed = 0;
        }

        @Override
        public int getSimulatedUseCount(int slot) {
            return this.milkUsed / 1000;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (this.tileMilkJar.getMilkAmount() - (float)this.milkUsed >= (float)(amount * 1000)) {
                if (requireBucket && ((ItemStack)this.itemStacks.get(slot)).func_77973_b() == Items.field_151117_aB && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return ItemStack.field_190927_a;
                }
                if (simulate) {
                    this.milkUsed += amount * 1000;
                } else {
                    this.tileMilkJar.drain(amount * 1000, IFluidHandler.FluidAction.EXECUTE);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.itemStacks.get(slot)), (int)amount);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemStack, (ItemStack)providedStack)) continue;
                this.tileMilkJar.fill(1000, IFluidHandler.FluidAction.EXECUTE);
                break;
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (this.tileMilkJar.getMilkAmount() - (float)this.milkUsed < 1000.0f) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)this.itemStacks.get(slot);
        }

        @Override
        public int getCountInSlot(int slot) {
            return (int)(this.tileMilkJar.getMilkAmount() / 1000.0f);
        }
    }
}

