/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.container.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlot;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotCraftMatrix;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotRecipe;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.message.MessageCraftRecipe;
import net.blay09.mods.cookingforblockheads.network.message.MessageItemList;
import net.blay09.mods.cookingforblockheads.network.message.MessageRecipes;
import net.blay09.mods.cookingforblockheads.network.message.MessageRequestRecipes;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.ItemHandlerHelper;

public class RecipeBookContainer
extends Container {
    private final PlayerEntity player;
    private final List<FakeSlotRecipe> recipeSlots = Lists.newArrayList();
    private final List<FakeSlotCraftMatrix> matrixSlots = Lists.newArrayList();
    private final InventoryCraftBook craftBook = new InventoryCraftBook(this);
    private boolean noFilter;
    private boolean allowCrafting;
    private KitchenMultiBlock multiBlock;
    private boolean isDirty = true;
    private ItemStack lastOutputItem = ItemStack.field_190927_a;
    private final List<FoodRecipeWithStatus> itemList = Lists.newArrayList();
    private Comparator<FoodRecipeWithStatus> currentSorting = new ComparatorName();
    private final List<FoodRecipeWithStatus> filteredItems = Lists.newArrayList();
    private boolean slotWasClicked;
    private String currentSearch;
    private boolean isDirtyClient;
    private boolean hasOven;
    private int scrollOffset;
    private FoodRecipeWithStatus selectedRecipe;
    private List<FoodRecipeWithIngredients> selectedRecipeList;
    private int selectedRecipeIndex;
    private boolean isInNoFilterPreview;

    public RecipeBookContainer(ContainerType<RecipeBookContainer> containerType, int windowId, PlayerEntity player) {
        super(containerType, windowId);
        FakeSlot slot;
        int j;
        int i;
        this.player = player;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new FakeSlotRecipe(j + i * 3, 102 + j * 18, 11 + i * 18);
                this.recipeSlots.add((FakeSlotRecipe)slot);
                this.func_75146_a(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new FakeSlotCraftMatrix(j + i * 3, 24 + j * 18, 20 + i * 18);
                this.matrixSlots.add((FakeSlotCraftMatrix)slot);
                this.func_75146_a(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 150));
        }
    }

    public ItemStack func_184996_a(int slotNumber, int dragType, ClickType clickType, PlayerEntity player) {
        this.slotWasClicked = true;
        if (slotNumber >= 0 && slotNumber < this.field_75151_b.size()) {
            Slot slot = (Slot)this.field_75151_b.get(slotNumber);
            if (player.field_70170_p.field_72995_K && slot instanceof FakeSlotRecipe) {
                FakeSlotRecipe slotRecipe = (FakeSlotRecipe)slot;
                if (this.selectedRecipe != null && slotRecipe.getRecipe() == this.selectedRecipe) {
                    FoodRecipeWithIngredients recipe;
                    if (this.allowCrafting && (clickType == ClickType.QUICK_MOVE || clickType == ClickType.PICKUP) && (recipe = this.getSelection()) != null) {
                        NonNullList craftMatrix = NonNullList.func_191196_a();
                        if (recipe.getRecipeType() == RecipeType.CRAFTING) {
                            for (FakeSlotCraftMatrix matrixSlot : this.matrixSlots) {
                                craftMatrix.add((Object)matrixSlot.func_75211_c());
                            }
                        } else if (recipe.getRecipeType() == RecipeType.SMELTING) {
                            craftMatrix.add((Object)this.matrixSlots.get(4).func_75211_c());
                        }
                        NetworkHandler.channel.sendToServer((Object)new MessageCraftRecipe(recipe.getOutputItem(), recipe.getRecipeType(), (NonNullList<ItemStack>)craftMatrix, clickType == ClickType.QUICK_MOVE));
                    }
                } else {
                    this.setSelectedRecipe(slotRecipe.getRecipe(), false);
                }
            }
        }
        return super.func_184996_a(slotNumber, dragType, clickType, player);
    }

    public void setSelectedRecipe(@Nullable FoodRecipeWithStatus recipe, boolean forceNoFilter) {
        this.selectedRecipe = recipe;
        if (this.selectedRecipe != null) {
            NetworkHandler.channel.sendToServer((Object)new MessageRequestRecipes(this.selectedRecipe.getOutputItem(), forceNoFilter));
        }
        this.isInNoFilterPreview = forceNoFilter;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.field_70170_p.field_72995_K && (this.isDirty || this.slotWasClicked)) {
            this.findAndSendItemList();
            if (!this.lastOutputItem.func_190926_b()) {
                this.findAndSendRecipes(this.lastOutputItem, this.isInNoFilterPreview);
            }
            this.slotWasClicked = false;
            this.isDirty = false;
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    public void func_75130_a(IInventory inventory) {
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex >= 48 && slotIndex < 57 ? !this.func_75135_a(slotStack, 21, 48, true) : slotIndex >= 21 && slotIndex < 48 && !this.func_75135_a(slotStack, 48, 57, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    public RecipeBookContainer setNoFilter() {
        this.noFilter = true;
        return this;
    }

    public RecipeBookContainer allowCrafting() {
        this.allowCrafting = true;
        return this;
    }

    public RecipeBookContainer setKitchenMultiBlock(KitchenMultiBlock kitchenMultiBlock) {
        this.multiBlock = kitchenMultiBlock;
        return this;
    }

    public void findAndSendItemList() {
        HashMap statusMap = Maps.newHashMap();
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(this.multiBlock, this.player.field_71071_by);
        block0: for (ResourceLocation key : CookingRegistry.getFoodRecipes().keySet()) {
            Enum bestStatus = null;
            for (FoodRecipe recipe : CookingRegistry.getFoodRecipes().get((Object)key)) {
                RecipeStatus thisStatus = CookingRegistry.getRecipeStatus(recipe, inventories, this.multiBlock != null && this.multiBlock.hasSmeltingProvider());
                if (!(!this.noFilter && thisStatus == RecipeStatus.MISSING_INGREDIENTS || bestStatus != null && thisStatus.ordinal() <= bestStatus.ordinal())) {
                    statusMap.put(key, new FoodRecipeWithStatus(recipe.getOutputItem(), thisStatus));
                    bestStatus = thisStatus;
                }
                if (bestStatus != RecipeStatus.AVAILABLE) continue;
                continue block0;
            }
        }
        NetworkHandler.sendTo(new MessageItemList(statusMap.values(), this.multiBlock != null && this.multiBlock.hasSmeltingProvider()), this.player);
    }

    public void findAndSendRecipes(ItemStack outputItem, boolean forceNoFilter) {
        this.lastOutputItem = outputItem;
        this.isInNoFilterPreview = forceNoFilter;
        ArrayList resultList = Lists.newArrayList();
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(this.multiBlock, this.player.field_71071_by);
        block0: for (FoodRecipe recipe : CookingRegistry.getFoodRecipes(outputItem)) {
            for (IKitchenItemProvider itemProvider : inventories) {
                itemProvider.resetSimulation();
            }
            List<FoodIngredient> ingredients = recipe.getCraftMatrix();
            ArrayList craftMatrix = Lists.newArrayListWithCapacity((int)ingredients.size());
            boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
            int availabilityMap = 0;
            for (int i = 0; i < ingredients.size(); ++i) {
                FoodIngredient ingredient = ingredients.get(i);
                NonNullList stackList = NonNullList.func_191196_a();
                if (ingredient != null) {
                    List<SourceItem> sourceList = CookingRegistry.findSourceCandidates(ingredient, inventories, requireBucket, this.noFilter || forceNoFilter);
                    if (sourceList.isEmpty()) continue block0;
                    if (sourceList.stream().anyMatch(it -> it.getSourceProvider() != null)) {
                        int origX = i % recipe.getRecipeWidth();
                        int origY = i / recipe.getRecipeWidth();
                        int targetIdx = origY * 3 + origX;
                        availabilityMap |= 1 << targetIdx;
                    }
                    for (SourceItem source : sourceList) {
                        ItemStack foundStack = source.getSourceStack();
                        stackList.add((Object)(foundStack.func_190916_E() > 127 ? ItemHandlerHelper.copyStackWithSize((ItemStack)foundStack, (int)127) : foundStack));
                    }
                }
                craftMatrix.add(stackList);
            }
            RecipeStatus recipeStatus = CookingRegistry.getRecipeStatus(recipe, inventories, this.multiBlock != null && this.multiBlock.hasSmeltingProvider());
            resultList.add(FoodRecipeWithIngredients.fromFoodRecipe(recipe, recipeStatus, craftMatrix, availabilityMap));
        }
        resultList.sort((o1, o2) -> o2.getRecipeStatus().ordinal() - o1.getRecipeStatus().ordinal());
        NetworkHandler.sendTo(new MessageRecipes(outputItem, resultList), this.player);
    }

    public void tryCraft(ItemStack outputItem, RecipeType recipeType, NonNullList<ItemStack> craftMatrix, boolean stack) {
        if (outputItem.func_190926_b() || craftMatrix.size() == 0) {
            return;
        }
        if (this.allowCrafting) {
            if (recipeType == RecipeType.CRAFTING) {
                ItemStack itemStack;
                int craftCount = stack ? outputItem.func_77976_d() / outputItem.func_190916_E() : 1;
                for (int i = 0; i < craftCount && !(itemStack = this.craftBook.tryCraft(outputItem, craftMatrix, this.player, this.multiBlock)).func_190926_b(); ++i) {
                    if (this.player.field_71071_by.func_70441_a(itemStack)) continue;
                    this.player.func_71019_a(itemStack, false);
                }
                this.isDirty = true;
                this.func_75142_b();
            } else if (recipeType == RecipeType.SMELTING && this.multiBlock != null && this.multiBlock.hasSmeltingProvider()) {
                this.multiBlock.trySmelt(outputItem, (ItemStack)craftMatrix.get(0), this.player, stack);
                this.isDirty = true;
            }
        }
    }

    public boolean isAllowCrafting() {
        return this.allowCrafting;
    }

    public void setItemList(Collection<FoodRecipeWithStatus> recipeList) {
        this.itemList.clear();
        this.itemList.addAll(recipeList);
        int previousSelectionIndex = this.selectedRecipe != null ? this.filteredItems.indexOf(this.selectedRecipe) : -1;
        this.search(this.currentSearch);
        this.filteredItems.sort(this.currentSorting);
        if (this.selectedRecipe != null && previousSelectionIndex != -1) {
            Iterator<FoodRecipeWithStatus> it = this.filteredItems.iterator();
            FoodRecipeWithStatus found = null;
            while (it.hasNext()) {
                FoodRecipeWithStatus recipe = it.next();
                if (!recipe.getOutputItem().func_77969_a(this.selectedRecipe.getOutputItem())) continue;
                found = recipe;
                it.remove();
                break;
            }
            while (previousSelectionIndex > this.filteredItems.size()) {
                this.filteredItems.add(null);
            }
            this.filteredItems.add(previousSelectionIndex, found);
            this.selectedRecipe = found;
        }
        this.populateRecipeSlots();
        this.setDirty(true);
    }

    public void populateRecipeSlots() {
        int i = this.scrollOffset * 3;
        for (FakeSlotRecipe slot : this.recipeSlots) {
            if (i < this.filteredItems.size()) {
                slot.setFoodRecipe(this.filteredItems.get(i));
                ++i;
                continue;
            }
            slot.setFoodRecipe(null);
        }
    }

    private void populateMatrixSlots() {
        FoodRecipeWithIngredients recipe = this.selectedRecipeList != null ? this.selectedRecipeList.get(this.selectedRecipeIndex) : null;
        this.populateMatrixSlots(recipe);
    }

    public void populateMatrixSlots(@Nullable FoodRecipeWithIngredients recipe) {
        if (recipe == null) {
            for (FakeSlotCraftMatrix matrixSlot : this.matrixSlots) {
                matrixSlot.setIngredient(null);
                matrixSlot.setAvailable(true);
            }
            return;
        }
        if (recipe.getRecipeType() == RecipeType.SMELTING) {
            for (int i = 0; i < this.matrixSlots.size(); ++i) {
                this.matrixSlots.get(i).setIngredient(i == 4 ? recipe.getCraftMatrix().get(0) : null);
                this.matrixSlots.get(i).setAvailable((recipe.getAvailabilityMap() & 1) == 1);
            }
        } else {
            int i;
            NonNullList[] matrix = new NonNullList[9];
            for (i = 0; i < recipe.getCraftMatrix().size(); ++i) {
                int origX = i % recipe.getRecipeWidth();
                int origY = i / recipe.getRecipeWidth();
                int targetIdx = origY * 3 + origX;
                matrix[targetIdx] = recipe.getCraftMatrix().get(i);
            }
            for (i = 0; i < matrix.length; ++i) {
                this.matrixSlots.get(i).setIngredient((NonNullList<ItemStack>)matrix[i]);
                this.matrixSlots.get(i).setAvailable((recipe.getAvailabilityMap() & 1 << i) == 1 << i);
            }
        }
    }

    public void setSortComparator(Comparator<FoodRecipeWithStatus> comparator) {
        this.currentSorting = comparator;
        this.filteredItems.removeIf(Objects::isNull);
        this.filteredItems.sort(comparator);
        this.populateRecipeSlots();
    }

    public int getItemListCount() {
        return this.filteredItems.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.populateRecipeSlots();
    }

    public void search(@Nullable String term) {
        this.scrollOffset = 0;
        this.currentSearch = term;
        this.filteredItems.clear();
        if (term == null || term.trim().isEmpty()) {
            this.filteredItems.addAll(this.itemList);
        } else {
            block0: for (FoodRecipeWithStatus recipe : this.itemList) {
                if (recipe.getOutputItem().func_200301_q().getString().toLowerCase(Locale.ENGLISH).contains(term.toLowerCase())) {
                    this.filteredItems.add(recipe);
                    continue;
                }
                List<ITextComponent> tooltips = CookingForBlockheads.proxy.getItemTooltip(recipe.getOutputItem(), this.player);
                for (ITextComponent tooltip : tooltips) {
                    if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(term.toLowerCase())) continue;
                    this.filteredItems.add(recipe);
                    continue block0;
                }
            }
        }
        this.filteredItems.sort(this.currentSorting);
    }

    @Nullable
    public FoodRecipeWithIngredients getSelection() {
        return this.selectedRecipeList != null ? this.selectedRecipeList.get(this.selectedRecipeIndex) : null;
    }

    public boolean isSelectedSlot(FakeSlotRecipe slot) {
        return slot.getRecipe() == this.selectedRecipe;
    }

    public boolean isDirty() {
        return this.isDirtyClient;
    }

    public void setDirty(boolean dirty) {
        this.isDirtyClient = dirty;
    }

    public void setHasOven(boolean hasOven) {
        this.hasOven = hasOven;
    }

    public boolean hasOven() {
        return this.hasOven;
    }

    public void setRecipeList(ItemStack outputItem, List<FoodRecipeWithIngredients> recipeList) {
        List<FoodRecipeWithIngredients> list = this.selectedRecipeList = recipeList.size() > 0 ? recipeList : null;
        if (this.lastOutputItem.func_190926_b() || this.lastOutputItem.func_77973_b() != outputItem.func_77973_b() || this.selectedRecipeList == null || this.selectedRecipeIndex >= this.selectedRecipeList.size()) {
            this.selectedRecipeIndex = 0;
        }
        this.populateMatrixSlots();
        this.lastOutputItem = outputItem;
    }

    public void nextSubRecipe(int i) {
        if (this.selectedRecipeList != null) {
            this.selectedRecipeIndex = Math.max(0, Math.min(this.selectedRecipeList.size() - 1, this.selectedRecipeIndex + i));
            this.populateMatrixSlots();
        }
    }

    public boolean hasVariants() {
        return this.selectedRecipeList != null && this.selectedRecipeList.size() > 1;
    }

    public void updateSlots(float partialTicks) {
        for (FakeSlotCraftMatrix slot : this.matrixSlots) {
            slot.updateSlot(partialTicks);
        }
    }

    public int getSelectionIndex() {
        return this.selectedRecipeIndex;
    }

    public int getRecipeCount() {
        return this.selectedRecipeList != null ? this.selectedRecipeList.size() : 0;
    }

    public List<FakeSlotCraftMatrix> getCraftingMatrixSlots() {
        return this.matrixSlots;
    }

    @Nullable
    public FoodRecipeWithStatus findAvailableRecipe(ItemStack itemStack) {
        return this.itemList.stream().filter(it -> ItemStack.func_179545_c((ItemStack)it.getOutputItem(), (ItemStack)itemStack)).findAny().orElse(null);
    }

    public int getSelectedRecipeIndex() {
        return this.filteredItems.indexOf(this.selectedRecipe);
    }
}

