/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.compat.CompatCapabilityLoader;
import net.blay09.mods.cookingforblockheads.compat.json.JsonCompatData;
import net.blay09.mods.cookingforblockheads.compat.json.OvenFuelData;
import net.blay09.mods.cookingforblockheads.compat.json.OvenRecipeData;
import net.blay09.mods.cookingforblockheads.compat.json.ToasterRecipeData;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class JsonCompatLoader
implements IResourceManagerReloadListener {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    private static final NonNullList<ItemStack> nonFoodRecipes = NonNullList.func_191196_a();

    public void func_195410_a(IResourceManager resourceManager) {
        try {
            for (ResourceLocation resourceLocation : resourceManager.func_199003_a("cookingforblockheads/compat", it -> it.endsWith(".json"))) {
                try {
                    IResource resource = resourceManager.func_199002_a(resourceLocation);
                    Throwable throwable = null;
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.func_199027_b());
                        JsonCompatLoader.load((JsonCompatData)gson.fromJson((Reader)reader, JsonCompatData.class));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (resource == null) continue;
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        resource.close();
                    }
                }
                catch (Exception e) {
                    CookingForBlockheads.logger.error("Parsing error loading CookingForBlockheads data files at {}", (Object)resourceLocation, (Object)e);
                }
            }
            for (Block kitchenFloor : ModBlocks.kitchenFloors) {
                KitchenMultiBlock.registerConnectorBlock(kitchenFloor);
            }
        }
        catch (Exception e) {
            CookingForBlockheads.logger.error("Error loading CookingForBlockheads data files", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onCookingRegistry(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : nonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }

    private static void load(JsonCompatData data) {
        ItemStack output;
        ItemStack input;
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !ModList.get().isLoaded(modId)) {
            return;
        }
        if (data.getFoods() != null) {
            for (List<ResourceLocation> list : data.getFoods().values()) {
                for (ResourceLocation registryName : list) {
                    JsonCompatLoader.findItemStack(registryName).ifPresent(arg_0 -> nonFoodRecipes.add(arg_0));
                }
            }
        }
        if (data.getTools() != null) {
            for (ResourceLocation registryName : data.getTools()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addToolItem);
            }
        }
        if (data.getWater() != null) {
            for (ResourceLocation registryName : data.getWater()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addWaterItem);
            }
        }
        if (data.getMilk() != null) {
            for (ResourceLocation registryName : data.getMilk()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addMilkItem);
            }
        }
        if (data.getOvenFuels() != null) {
            for (OvenFuelData ovenFuel : data.getOvenFuels()) {
                JsonCompatLoader.findItemStack(ovenFuel.getItem()).ifPresent(itemStack -> CookingForBlockheadsAPI.addOvenFuel(itemStack, ovenFuel.getValue()));
            }
        }
        if (data.getOvenRecipes() != null) {
            for (OvenRecipeData ovenRecipe : data.getOvenRecipes()) {
                input = JsonCompatLoader.findItemStack(ovenRecipe.getInput()).orElse(ItemStack.field_190927_a);
                output = JsonCompatLoader.findItemStack(ovenRecipe.getOutput()).orElse(ItemStack.field_190927_a);
                if (input.func_190926_b() || output.func_190926_b()) continue;
                CookingForBlockheadsAPI.addOvenRecipe(input, output);
            }
        }
        if (data.getToasterRecipes() != null) {
            for (ToasterRecipeData toasterRecipe : data.getToasterRecipes()) {
                input = JsonCompatLoader.findItemStack(toasterRecipe.getInput()).orElse(ItemStack.field_190927_a);
                output = JsonCompatLoader.findItemStack(toasterRecipe.getOutput()).orElse(ItemStack.field_190927_a);
                if (input.func_190926_b() || output.func_190926_b()) continue;
                CookingForBlockheadsAPI.addToasterHandler(input, itemStack -> output);
            }
        }
        if (data.getKitchenItemProviders() != null) {
            for (ResourceLocation kitchenItemProvider : data.getKitchenItemProviders()) {
                CompatCapabilityLoader.addKitchenItemProvider(kitchenItemProvider);
            }
        }
        if (data.getKitchenConnectors() != null) {
            for (ResourceLocation kitchenConnector : data.getKitchenConnectors()) {
                CompatCapabilityLoader.addKitchenConnector(kitchenConnector);
                Block connectorBlock = (Block)ForgeRegistries.BLOCKS.getValue(kitchenConnector);
                if (connectorBlock == null || connectorBlock == Blocks.field_150350_a) continue;
                KitchenMultiBlock.registerConnectorBlock(connectorBlock);
            }
        }
    }

    private static Optional<ItemStack> findItemStack(ResourceLocation registryName) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
        return item == null || item == Items.field_190931_a ? Optional.empty() : Optional.of(new ItemStack((IItemProvider)item));
    }
}

