/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="cookingforblockheads")
public class CompatCapabilityLoader {
    private static KitchenConnectorCapabilityProvider connectorCapabilityProvider;
    private static ResourceLocation itemProviderResourceKey;
    private static ResourceLocation connectorResourceKey;
    private static final Set<ResourceLocation> kitchenItemProviders;
    private static final Set<ResourceLocation> kitchenConnectors;
    private static final ItemStackHandler emptyItemHandler;

    public static void addKitchenItemProvider(ResourceLocation registryName) {
        kitchenItemProviders.add(registryName);
    }

    public static void addKitchenConnector(ResourceLocation registryName) {
        kitchenConnectors.add(registryName);
    }

    @SubscribeEvent
    public static void attachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity tileEntity = (TileEntity)event.getObject();
        if (kitchenItemProviders.contains(tileEntity.func_200662_C().getRegistryName())) {
            if (itemProviderResourceKey == null) {
                itemProviderResourceKey = new ResourceLocation("cookingforblockheads", "kitchen_item_provider");
            }
            event.addCapability(itemProviderResourceKey, (ICapabilityProvider)new KitchenItemCapabilityProvider(tileEntity));
        }
        if (kitchenConnectors.contains(tileEntity.func_200662_C().getRegistryName())) {
            if (connectorResourceKey == null) {
                connectorResourceKey = new ResourceLocation("cookingforblockheads", "kitchen_connector");
            }
            if (connectorCapabilityProvider == null) {
                connectorCapabilityProvider = new KitchenConnectorCapabilityProvider();
            }
            event.addCapability(connectorResourceKey, (ICapabilityProvider)connectorCapabilityProvider);
        }
    }

    static {
        kitchenItemProviders = new HashSet<ResourceLocation>();
        kitchenConnectors = new HashSet<ResourceLocation>();
        emptyItemHandler = new ItemStackHandler(0);
    }

    private static final class KitchenItemCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<IKitchenItemProvider> itemProviderCap = LazyOptional.of(() -> {
            LazyOptional itemHandlerCap = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return new KitchenItemProvider((IItemHandler)itemHandlerCap.orElse((Object)emptyItemHandler));
        });

        public KitchenItemCapabilityProvider(TileEntity entity) {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            return CapabilityKitchenItemProvider.CAPABILITY.orEmpty(capability, this.itemProviderCap);
        }
    }

    private static final class KitchenConnectorCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<CapabilityKitchenConnector.IKitchenConnector> kitchenConnectorCap = LazyOptional.of(() -> CapabilityKitchenConnector.CAPABILITY.getDefaultInstance());

        private KitchenConnectorCapabilityProvider() {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            return CapabilityKitchenConnector.CAPABILITY.orEmpty(capability, this.kitchenConnectorCap);
        }
    }
}

